/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.core.v2_1;

import com.roguewave.chart.overlay.core.v2_1.LinearScaler;
import com.roguewave.chart.overlay.core.v2_1.Log10Scaler;
import com.roguewave.chart.overlay.core.v2_1.Scaler;

public class ParameterCalculator {
    double scaleIncrement_;
    int lowIncrement_;
    int highIncrement_;
    int pixelsPerIncrement_;
    double low_;
    double high_;
    double scaleFactor_;
    Scaler scaler_;
    boolean isLinearScale_;

    public ParameterCalculator(double low, double high, double scaleIncrement, int height) {
        this.scaleIncrement_ = scaleIncrement;
        this.lowIncrement_ = (int)Math.floor(low / scaleIncrement);
        this.highIncrement_ = (int)Math.ceil(high / scaleIncrement);
        this.low_ = (double)this.lowIncrement_ * scaleIncrement;
        this.high_ = (double)this.highIncrement_ * scaleIncrement;
        this.pixelsPerIncrement_ = height / (this.highIncrement_ - this.lowIncrement_);
        this.scaleFactor_ = (double)this.pixelsPerIncrement_ / scaleIncrement;
        this.scaler_ = new LinearScaler(this.low_, this.scaleFactor_);
        this.isLinearScale_ = true;
    }

    public ParameterCalculator(double low, double high, int height) {
        this.lowIncrement_ = (int)Math.floor(Log10Scaler.log10(low));
        this.highIncrement_ = (int)Math.ceil(Log10Scaler.log10(high));
        this.low_ = Math.pow(10.0, this.lowIncrement_);
        this.high_ = Math.pow(10.0, this.highIncrement_);
        this.pixelsPerIncrement_ = height / (this.highIncrement_ - this.lowIncrement_);
        this.scaler_ = new Log10Scaler(this.lowIncrement_, this.pixelsPerIncrement_);
        this.scaleFactor_ = 1.0;
        this.scaleIncrement_ = 1.0;
        this.isLinearScale_ = false;
    }

    public static double calculateScaleIncrement(double low, double high) {
        double scaleIncrement = 10.0;
        double range = high - low;
        while (range / scaleIncrement > (double)10) {
            scaleIncrement *= (double)10;
        }
        while (range / scaleIncrement < (double)5) {
            scaleIncrement /= (double)2;
        }
        return scaleIncrement;
    }

    public void recalculateWith(int pixelsPerIncrement) {
        this.pixelsPerIncrement_ = pixelsPerIncrement;
        if (this.isLinearScale_) {
            this.scaleFactor_ = (double)pixelsPerIncrement / this.scaleIncrement_;
            this.scaler_ = new LinearScaler(this.low_, this.scaleFactor_);
        } else {
            this.scaler_ = new Log10Scaler(this.lowIncrement_, this.pixelsPerIncrement_);
        }
    }

    public double getScaleIncrement() {
        return this.scaleIncrement_;
    }

    public int getLowIncrement() {
        return this.lowIncrement_;
    }

    public int getHighIncrement() {
        return this.highIncrement_;
    }

    public int getPixelsPerIncrement() {
        return this.pixelsPerIncrement_;
    }

    public double getMinValue() {
        return this.low_;
    }

    public double getMaxValue() {
        return this.high_;
    }

    public double getScaleFactor() {
        return this.scaleFactor_;
    }

    public Scaler getScaler() {
        return this.scaler_;
    }
}

